//
// Object Array.js
//
//  v.111110
//  tested version : Cheetah3D v5.6
//
//  (c) 2011, 2007 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//

function buildUI(obj) {
    
    obj.setParameter('name','Object Array');
    
    obj.addParameterSelector('array type', ['line','grid','ring', 'spline'],false,false);
    obj.addParameterLink('target', true);
    obj.addParameterButton('update', 'update', 'arrayUpdate');
    
    obj.addParameterSeparator('Parameters - line');
    
    obj.addParameterSelector('line axis',['x','y','z'],false,false);
    obj.addParameterFloat('line distance',1.0,-1000000,1000000,false,false);
    
    obj.addParameterSeparator('Parameters - grid');
    obj.addParameterSelector('grid plane',['xz','xy','yz'],false,false);
    obj.addParameterInt('grid w count',2,1,100,false,false);
    obj.addParameterFloat('grid w distance',1.0,-1000000,1000000,false,false);
    obj.addParameterFloat('grid h distance',1.0,-1000000,1000000,false,false);
    
    obj.addParameterSeparator('Parameters - ring');
    obj.addParameterSelector('ring plane',['xz','xy','yz'],false,false);
    obj.addParameterFloat('ring angle',360,0,360,false,false);
    obj.addParameterFloat('ring radius',1.0,0,1000000,false,false);
    
    obj.addParameterSeparator('Parameters - spline');
    obj.addParameterLink('guide spline', true);
    obj.addParameterInt('subpath index', 0, 0, 10000,false,false);
    
}

function arrayUpdate(obj) {
    obj.update();
}

function buildObject(obj) {
    var target = obj.getParameter("target");
    if (!target || target.type() != FOLDER) return;
    
	var i;
	var childCount = target.childCount();

	var arrayType = parseInt(obj.getParameter('array type'));
	
	var lineAxis = parseInt(obj.getParameter('line axis'));
	var distance = obj.getParameter('line distance');
	var gridPlane = parseInt(obj.getParameter('grid plane'));
	var gridWCount = obj.getParameter('grid w count');
	var gridWDist = obj.getParameter('grid w distance');
	var gridHDist = obj.getParameter('grid h distance');
	var ringPlane = parseInt(obj.getParameter('ring plane'));
	var ringRadius = obj.getParameter('ring radius');
	var ringAngle = obj.getParameter('ring angle');
	
    if (arrayType == 3) {
        var spl = obj.getParameter("guide spline");
        var splIndex = obj.getParameter("subpath index");
        if (!spl || spl.family() != SPLINEFAMILY) return;
        var splCore = spl.modCore();
        
        var splMat = spl.objMatrix();
        
        splHolder = splCore.cache( splIndex );
        if (!splHolder) return;
        
        cacheSplineLength();
        
        var totalLength = calcSplineLength( splHolder, splList );
    }
    
	for (i = 0;i < childCount;i++) {
		var cObj = target.childAtIndex(i);
		
		switch(arrayType) {
			case 0:
				// type line
				switch(lineAxis) {
					case 0:
						cObj.setParameter('position',new Vec3D(distance*i,0,0));
						break;
					case 1:
						cObj.setParameter('position',new Vec3D(0,distance*i,0));
						break;
					case 2:
						cObj.setParameter('position',new Vec3D(0,0,distance*i));
						break;
				}
				break;
			case 1:
				// type grid
				
				var x = gridWDist * parseInt(i / gridWCount);
				var y = gridHDist * (i % gridWCount);
				
				setPositionByPlane(gridPlane, cObj, x, y);
				break;
			case 2:
				// type ring
				if (ringAngle == 360.0) {
					var ringRadius_dt = ringAngle/childCount;
				} else {
					var ringRadius_dt = ringAngle/(childCount-1); // if angle < 360
				}
				var x = ringRadius * Math.cos(2*Math.PI*(ringRadius_dt*i)/360);
				var y = ringRadius * Math.sin(2*Math.PI*(ringRadius_dt*i)/360);
				
				setPositionByPlane(ringPlane, cObj, x, y);
				break;
            case 3:
                // type spline
                
                if (splHolder[0].isEqual( splHolder[ splHolder.length - 1 ] )) {
                    cObj.setParameter("position", pointFromPercentage( i / childCount, splMat ));
                } else {
                    cObj.setParameter("position", pointFromPercentage( i / (childCount - 1), splMat ));
                }
                break;
		}
	}
}

var splHolder = [];
var splList = [];

function setPositionByPlane(plane, obj, x, y) {
	switch(plane) {
		case 0:
			obj.setParameter('position', new Vec3D(x, 0, y));
			break;
		case 1:
			obj.setParameter('position', new Vec3D(x, y, 0));
			break;
		case 2:
			obj.setParameter('position', new Vec3D(0, x, y));
			break;
	}
}

// these functions from Todd's Loft.js script.
// thank you for sharing, Todd. :D

function calcSplineLength(points,lst) {
	var l = points.length;
	var i;
	var accum = 0;
	lst[0] = 0;
	for(i=0;i<l-1;i++) {
		var p = points[i+1].sub(points[i]);
		accum = accum + Math.sqrt( p.x * p.x + p.y * p.y + p.z * p.z);
		lst[i+1] = accum;
	}
	for(i=0;i<l;i++) {
		lst[i] = lst[i]/accum;
	}
	return accum;
}

function pointFromPercentage(percent, mat) { // these spline stuff from Todd's Loft.js
    if (percent < 0 && percent > 1) return new Vec3D(0,0,0);
    var i; var hi = splHolder.length - 1; var lo = 0;
    var d = percent;
    while (hi - lo > 1) {
        i = Math.floor((hi+lo)/2);
        if (percent <= splList[i]) {
            hi = i;
            continue;
        }
        if (percent > splList[i]) {
            lo = i;
        }
    }
    i = hi;
    
    var p1 = splHolder[i-1];
    var p2 = splHolder[i];
    //
    d = (d - splList[i-1])/(splList[i] - splList[i-1]);
    p1 = p1.multiply(1-d).add(p2.multiply(d));
    return mat.multiply(p1);
}

function asyVecFromPercentage(percent, mat, m) {
    if (1-m > percent) {
        var prePer = percent - m;
        var posPer = percent;
    } else if (m > percent) {
        var prePer = 0;
        var posPer = percent + m;
    } else {
        var prePer = percent - m;
        var posPer = percent + m;
    }
    prePos = pointFromPercentage( prePer, mat );
    posPos = pointFromPercentage( posPer, mat );
    
    var asyVec = posPos.sub(prePos);
    var norm = asyVec.norm();
    
    return (norm == 0)? asyVec.multiply(0) : asyVec.multiply( 1/norm ) ;
}

function cacheSplineLength() {
    var l = splHolder.length;
    var i;

    var accum = 0;
    splList[0] = 0;
    for (i = 0;i < l - 1;i++) {
        var p = splHolder[i+1].sub(splHolder[i]);
        accum = accum + Math.sqrt( p.x * p.x + p.y * p.y + p.z * p.z);
        splList[i+1] = accum;
    }
    for (i = 0;i < l;i++) {
        splList[i] = splList[i] / accum;
    }
}
